<?php
require_once( 'utility.php' ) ;

function configure_liteserver( $argv ) {
	global $DTASCFG_XML_FILE, $BACKEND ;

	$xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;

	$esxi_ip       = chop( $xml->esxi->ip ) ;
	$esxi_username = chop( $xml->esxi->username ) ;
	$esxi_password = $xml->esxi->password ;

	$sc_username = chop( $xml->sandbox_controller->admin_username ) ;
	$sc_password = $xml->sandbox_controller->admin_password;
	$sc_dir      = chop( $xml->sandbox_controller->ctrl_dir ) ;
	$sc_prefix   = chop( $xml->sandbox_controller->prefix ) ;
	$sc_vmpath   = chop( $xml->sandbox_controller->image_path ) ;
	$dtas_dir    = chop( $xml->cli->dtas_dir ) ;
	
	$liteserverd = chop( $xml->cli->liteserverd_path ) ;	
	
	/* sandbox controller should power on, but we try to power on it again */
	debug_print( "power-on sandbox_controller: $sc_vmpath ..." ) ;
	start_vm_and_wait( $esxi_ip, $esxi_username, $esxi_password, $sc_vmpath ) ;
	
    debug_print( "copy \"sandcastle.zip\" to sandbox_controller ..." ) ;    
    copy_file_to_sc( array(
        'from' => dirname(__FILE__) . "/../sandcastle.zip",
        'to'   => "$sc_dir/sandcastle.zip"
    ) ) ;
	
	debug_print( "unzip sandbox_controller's \"sandcastle.zip\" to $dtas_dir ..." ) ;
    run_program_at_sc_by_ssh( array(
        'program'   => "/usr/bin/unzip", 
        'arguments' => array(
            "$sc_dir/sandcastle.zip",
            "-d",
            "$dtas_dir" ) ) ) ;

	
	debug_print( "change following files to be executable: " ) ;
	debug_print( "    <sandbox_controller> $dtas_dir/sandcastle/server/liteserver" ) ;
	debug_print( "    <sandbox_controller> $dtas_dir/sandcastle/server/revert.sh" ) ;
    run_program_at_sc_by_ssh( array(
        'program'   => "/bin/chmod", 
        'arguments' => array(
            "+x",
            "$dtas_dir/sandcastle/server/liteserver",
            "$dtas_dir/sandcastle/server/revert.sh" ) ) ) ;

	debug_print( "create \"revertd.conf\" ... " ) ;
	create_revertd_conf( dirname(__FILE__) . "/../revertd.conf" ) ;

	debug_print( "copy \"revertd.conf\" to sandbox_controller ..." ) ;
    copy_file_to_sc( array(
        'from' => dirname(__FILE__) . "/../revertd.conf",
        'to'   => "$dtas_dir/SandboxController/bin/revertd/revertd.conf"
    ) ) ;
	
	debug_print( "launch \"revertd\" ..." ) ;
    run_program_at_sc_by_ssh( array(
        'program'   => "/sbin/chkconfig", 
        'arguments' => array(
            "--add",
            "revertd" ) ) ) ;

    run_program_at_sc_by_ssh( array(
        'program'   => "/sbin/chkconfig", 
        'arguments' => array(
            "--level",
            "2345",
            "revertd",
            "on" ) ) ) ;
        
    run_program_at_sc_by_ssh( array(
        'program'   => "/sbin/service",
        'arguments' => array(
            "revertd",
            "start" ) ) ) ;
        
	debug_print( "create \"LiteServer.ini\" ... " ) ;
    create_liteserver_ini( dirname(__FILE__) . "/../LiteServer.ini", dirname(__FILE__) . "/../IPUsage" ) ;
	
	debug_print( "copy \"LiteServer.ini\" to sandbox_controller ..." ) ;
    copy_file_to_sc( array(
        'from' => dirname(__FILE__) . "/../LiteServer.ini",
        'to'   => "$dtas_dir/sandcastle/server/LiteServer.ini"
    ) ) ;

	
	debug_print( "launch \"liteserverd\" ..." ) ;
    run_program_at_sc_by_ssh( array(
        'program'   => "$liteserverd",
        'arguments' => array(
            "--noWait" ) ) ) ;
}

